/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileIfLongUnused
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final HtmlColor arrowColor;

    private FtileIfLongUnused(List<Ftile> diamonds, List<Ftile> tiles, Ftile tile2, HtmlColor arrowColor) {
        super(tiles.get(0).shadowing() || tile2.shadowing());
        this.diamonds = diamonds;
        this.tiles = tiles;
        this.tile2 = tile2;
        this.arrowColor = arrowColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        for (Ftile tile : this.tiles) {
            result.addAll(tile.getSwimlanes());
        }
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamonds.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, UFont font, HtmlColor arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> thens, Branch branch2, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        int i;
        ArrayList<Ftile> tiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            tiles.add(new FtileMinWidth(branch.getFtile(), 30.0));
        }
        FtileMinWidth tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        FontConfiguration fc = new FontConfiguration(font, HtmlColorUtils.BLACK, hyperlinkColor, useUnderlineForHyperlink);
        ArrayList<Ftile> diamonds = new ArrayList<Ftile>();
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (Branch branch : thens) {
            TextBlock tb1 = branch.getLabelPositive().create(fc, HorizontalAlignment.LEFT, ftileFactory);
            TextBlock tbTest = branch.getLabelTest().create(fc, HorizontalAlignment.LEFT, ftileFactory);
            FtileDiamondInside diamond = new FtileDiamondInside(branch.shadowing(), backColor, borderColor, swimlane, tbTest);
            diamond = diamond.withNorth(tb1);
            diamonds.add(diamond);
        }
        TextBlock tb2 = branch2.getLabelPositive().create(fc, HorizontalAlignment.LEFT, ftileFactory);
        int last = diamonds.size() - 1;
        diamonds.set(last, ((FtileDiamondInside)diamonds.get(last)).withEast(tb2));
        FtileIfLongUnused result = new FtileIfLongUnused(diamonds, tiles, tile2, arrowColor);
        for (i = 0; i < thens.size(); ++i) {
            Ftile ftile = (Ftile)tiles.get(i);
            Ftile diam = (Ftile)diamonds.get(i);
            HtmlColor color = thens.get(i).getInlinkRenderingColor();
            FtileIfLongUnused ftileIfLongUnused = result;
            ftileIfLongUnused.getClass();
            conns.add(ftileIfLongUnused.new ConnectionVerticalIn(diam, ftile, color == null ? arrowColor : color));
            FtileIfLongUnused ftileIfLongUnused2 = result;
            ftileIfLongUnused2.getClass();
            conns.add(ftileIfLongUnused2.new ConnectionVerticalOut(ftile, arrowColor));
        }
        for (i = 0; i < diamonds.size() - 1; ++i) {
            Ftile diam1 = (Ftile)diamonds.get(i);
            Ftile diam2 = (Ftile)diamonds.get(i + 1);
            FtileIfLongUnused ftileIfLongUnused = result;
            ftileIfLongUnused.getClass();
            conns.add(ftileIfLongUnused.new ConnectionHorizontal(diam1, diam2, arrowColor));
        }
        FtileIfLongUnused ftileIfLongUnused = result;
        ftileIfLongUnused.getClass();
        conns.add(ftileIfLongUnused.new ConnectionIn(arrowColor));
        FtileIfLongUnused ftileIfLongUnused3 = result;
        ftileIfLongUnused3.getClass();
        conns.add(ftileIfLongUnused3.new ConnectionLastElseIn(arrowColor));
        FtileIfLongUnused ftileIfLongUnused4 = result;
        ftileIfLongUnused4.getClass();
        conns.add(ftileIfLongUnused4.new ConnectionLastElseOut(arrowColor));
        FtileIfLongUnused ftileIfLongUnused5 = result;
        ftileIfLongUnused5.getClass();
        conns.add(ftileIfLongUnused5.new ConnectionHline(arrowColor));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.tiles.contains(child)) {
            return this.getTranslate1(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = dimTotal.getWidth() - ((Dimension2D)dim2).getWidth();
        double h = this.getAllDiamondsHeight(stringBounder);
        double y2 = (dimTotal.getHeight() - h * 2.0 - ((Dimension2D)dim2).getHeight()) / 2.0 + h;
        return new UTranslate(x2, y2);
    }

    private UTranslate getTranslateDiamond1(Ftile diamond1, StringBounder stringBounder) {
        double x1 = 0.0;
        for (Ftile diamond : this.diamonds) {
            FtileGeometry dim1 = this.dimDiamondAndTile(stringBounder, diamond);
            if (diamond == diamond1) {
                FtileGeometry dimDiamond = diamond.calculateDimension(stringBounder);
                double xresult = x1 + dim1.getLeft() - dimDiamond.getLeft();
                return new UTranslate(xresult, 25.0);
            }
            x1 += dim1.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    private UTranslate getTranslate1(Ftile tile1, StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        double x1 = 0.0;
        for (Ftile tile : this.tiles) {
            FtileGeometry dim1 = this.dimDiamondAndTile(stringBounder, tile);
            if (tile == tile1) {
                FtileGeometry dimTile = tile.calculateDimension(stringBounder);
                double h = this.getAllDiamondsHeight(stringBounder);
                double y1 = (dimTotal.getHeight() - 2.0 * h - ((Dimension2D)dimTile).getHeight()) / 2.0 + h;
                return new UTranslate(x1 + (((Dimension2D)dim1).getWidth() - ((Dimension2D)dimTile).getWidth()) / 2.0, y1);
            }
            x1 += ((Dimension2D)dim1).getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile tile : this.tiles) {
            ug.apply(this.getTranslate1(tile, stringBounder)).draw(tile);
        }
        for (Ftile diamond : this.diamonds) {
            ug.apply(this.getTranslateDiamond1(diamond, stringBounder)).draw(diamond);
        }
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> all = new ArrayList<Ftile>(this.tiles);
        all.add(this.tile2);
        for (Ftile tmp : all) {
            if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimTotal, dimTotal.getWidth() / 2.0, 0.0, dimTotal.getHeight());
        }
        return new FtileGeometry(dimTotal, dimTotal.getWidth() / 2.0, 0.0);
    }

    private FtileGeometry dimDiamondAndTile(StringBounder stringBounder, Ftile tileOrDiamond) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            Ftile tile = this.tiles.get(i);
            Ftile diamond = this.diamonds.get(i);
            if (tile != tileOrDiamond && diamond != tileOrDiamond) continue;
            FtileGeometry dimTile = tile.calculateDimension(stringBounder);
            FtileGeometry dimDiamond = diamond.calculateDimension(stringBounder);
            return dimDiamond.appendBottom(dimTile);
        }
        throw new UnsupportedOperationException();
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimOnlyTiles = new Dimension2DDouble(0.0, 0.0);
        Dimension2D dimOnlyDiamond = new Dimension2DDouble(0.0, 0.0);
        Dimension2D dimBoth = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < this.tiles.size(); ++i) {
            Ftile tile = this.tiles.get(i);
            Ftile diamond = this.diamonds.get(i);
            FtileGeometry dimTile = tile.calculateDimension(stringBounder);
            FtileGeometry dimDiamond = diamond.calculateDimension(stringBounder);
            FtileGeometry both = dimDiamond.appendBottom(dimTile);
            dimOnlyTiles = Dimension2DDouble.mergeLR(dimOnlyTiles, dimTile);
            dimOnlyDiamond = Dimension2DDouble.mergeLR(dimOnlyDiamond, dimDiamond);
            dimBoth = Dimension2DDouble.mergeLR(dimBoth, both);
        }
        FtileGeometry dimTile2 = this.tile2.calculateDimension(stringBounder);
        dimOnlyTiles = Dimension2DDouble.mergeLR(dimOnlyTiles, dimTile2);
        dimBoth = Dimension2DDouble.mergeLR(dimBoth, dimTile2);
        Dimension2DDouble result = new Dimension2DDouble(dimBoth.getWidth(), ((Dimension2D)dimOnlyDiamond).getHeight() * 4.0 + dimOnlyTiles.getHeight());
        return Dimension2DDouble.delta(result, 20.0 * (double)this.tiles.size(), 40.0);
    }

    private double getAllDiamondsHeight(StringBounder stringBounder) {
        Dimension2D dimOnlyDiamond = new Dimension2DDouble(0.0, 0.0);
        for (Ftile diamond : this.diamonds) {
            FtileGeometry dimDiamond = diamond.calculateDimension(stringBounder);
            dimOnlyDiamond = Dimension2DDouble.mergeLR(dimOnlyDiamond, dimDiamond);
        }
        return ((Dimension2D)dimOnlyDiamond).getHeight();
    }

    class ConnectionHline
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionHline(HtmlColor arrowColor) {
            super(null, null);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Dimension2D totalDim = FtileIfLongUnused.this.calculateDimensionInternal(stringBounder);
            ArrayList<Ftile> all = new ArrayList<Ftile>(FtileIfLongUnused.this.tiles);
            all.add(FtileIfLongUnused.this.tile2);
            double minX = totalDim.getWidth() / 2.0;
            double maxX = totalDim.getWidth() / 2.0;
            for (Ftile tmp : all) {
                if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
                UTranslate ut = FtileIfLongUnused.this.getTranslateFor(tmp, stringBounder);
                double out = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, out);
                maxX = Math.max(maxX, out);
            }
            Snake s = new Snake(this.arrowColor);
            s.goUnmergeable();
            double height = totalDim.getHeight();
            s.addPoint(minX, height);
            s.addPoint(maxX, height);
            ug.draw(s);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalOut(Ftile tile, HtmlColor color) {
            super(tile, null);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            double totalHeight = FtileIfLongUnused.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            Point2D.Double p2 = new Point2D.Double(p1.getX(), totalHeight);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            Point2D p = geo.getPointOut();
            return FtileIfLongUnused.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalIn(Ftile diamond, Ftile tile, HtmlColor color) {
            super(diamond, tile);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D p = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongUnused.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D p = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongUnused.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseOut(HtmlColor arrowColor) {
            super(FtileIfLongUnused.this.tile2, null);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate tr1 = FtileIfLongUnused.this.getTranslate2(stringBounder);
            FtileGeometry dim = this.getFtile1().calculateDimension(stringBounder);
            if (!dim.hasPointOut()) {
                return;
            }
            Point2D p1 = tr1.getTranslated(dim.getPointOut());
            double totalHeight = FtileIfLongUnused.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D.Double p2 = new Point2D.Double(p1.getX(), totalHeight);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseIn(HtmlColor arrowColor) {
            super((Ftile)FtileIfLongUnused.this.diamonds.get(FtileIfLongUnused.this.diamonds.size() - 1), FtileIfLongUnused.this.tile2);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            Point2D p1 = this.getP1(ug.getStringBounder());
            UTranslate tr2 = FtileIfLongUnused.this.getTranslate2(ug.getStringBounder());
            Point2D p2 = tr2.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(dimDiamond1.getWidth(), dimDiamond1.getOutY() / 2.0);
            return FtileIfLongUnused.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor arrowColor) {
            super(null, (Ftile)FtileIfLongUnused.this.diamonds.get(0));
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            UTranslate tr = FtileIfLongUnused.this.getTranslateDiamond1(this.getFtile2(), ug.getStringBounder());
            Point2D p2 = tr.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D p1 = FtileIfLongUnused.this.calculateDimension(ug.getStringBounder()).getPointIn();
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionHorizontal(Ftile diam1, Ftile diam2, HtmlColor color) {
            super(diam1, diam2);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToRight());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(dimDiamond1.getWidth(), dimDiamond1.getOutY() / 2.0);
            return FtileIfLongUnused.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(0.0, dimDiamond1.getOutY() / 2.0);
            return FtileIfLongUnused.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }
}

